/*
 * Decompiled with CFR 0.152.
 */
package aeonics.manager.impl;

import aeonics.data.Data;
import aeonics.manager.Config;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.template.Parameter;
import aeonics.template.Template;
import aeonics.util.Callback;
import aeonics.util.Functions;
import aeonics.util.Json;
import aeonics.util.Tuples;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class DefaultConfig
extends Manager<Config> {
    protected Class<? extends Implementation> defaultTarget() {
        return Implementation.class;
    }

    protected Supplier<? extends Implementation> defaultCreator() {
        return () -> new Implementation();
    }

    public Template<? extends Config> template() {
        return super.template().summary("In memory configuration").description("Stores all the configuration parameters directly in memory. Environment variables and system properties are imported by default. They will be sanitized: Entity_Type_NAME will be converted to the configuration parameter entity type > name. This means that the 'name' part must not contain non-alphanumeric characters.").onCreate((data, config) -> {
            String string;
            for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                string = Config.sanitize((String)entry.getKey());
                if (string.isBlank() || string.replaceAll("\\.", "").isBlank()) continue;
                config.set(string, (Object)entry.getValue());
            }
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                string = Config.sanitize((String)entry.getKey().toString());
                if (string.isBlank() || string.replaceAll("\\.", "").isBlank()) continue;
                config.set(string, (Object)Data.of((Object)entry.getValue().toString()));
            }
        });
    }

    private static class Implementation
    extends Config {
        private Map<String, Tuples.Tuple<Data, Tuples.Tuple<Callback<Tuples.Tuple<String, Data>, Config>, Parameter>>> store = new HashMap<String, Tuples.Tuple<Data, Tuples.Tuple<Callback<Tuples.Tuple<String, Data>, Config>, Parameter>>>();

        private Implementation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void declare(String string, Parameter parameter) {
            Objects.requireNonNull(string);
            Objects.requireNonNull(parameter);
            Map<String, Tuples.Tuple<Data, Tuples.Tuple<Callback<Tuples.Tuple<String, Data>, Config>, Parameter>>> map = this.store;
            synchronized (map) {
                String string2 = Implementation.implodeName((String)string, (String)parameter.name());
                Tuples.Tuple<Data, Tuples.Tuple<Callback<Tuples.Tuple<String, Data>, Config>, Parameter>> tuple = this.store.get(string2);
                if (tuple == null) {
                    this.store.put(string2, (Tuples.Tuple<Data, Tuples.Tuple<Callback<Tuples.Tuple<String, Data>, Config>, Parameter>>)new Tuples.Tuple((Object)parameter.defaultValue(), (Object)new Tuples.Tuple(null, (Object)parameter)));
                } else {
                    ((Tuples.Tuple)tuple.b).b = parameter;
                }
            }
        }

        public Parameter definition(String string, String string2) {
            if (string == null || string.isBlank() || string2 == null || string2.isBlank()) {
                return null;
            }
            String string3 = Implementation.implodeName((String)string, (String)string2);
            Tuples.Tuple<Data, Tuples.Tuple<Callback<Tuples.Tuple<String, Data>, Config>, Parameter>> tuple = this.store.get(string3);
            if (tuple == null) {
                return null;
            }
            return (Parameter)((Tuples.Tuple)tuple.b).b;
        }

        public Data get(String string, String string2) {
            if (string == null || string.isBlank() || string2 == null || string2.isBlank()) {
                return Data.empty();
            }
            String string3 = Implementation.implodeName((String)string, (String)string2);
            Tuples.Tuple<Data, Tuples.Tuple<Callback<Tuples.Tuple<String, Data>, Config>, Parameter>> tuple = this.store.get(string3);
            if (tuple == null) {
                return Data.empty();
            }
            return ((Parameter)((Tuples.Tuple)tuple.b).b).resolve((Data)tuple.a, null);
        }

        public boolean contains(String string, String string2) {
            if (string == null || string.isBlank() || string2 == null || string2.isBlank()) {
                return false;
            }
            String string3 = Implementation.implodeName((String)string, (String)string2);
            return this.store.containsKey(string3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Data set(String string, String string3, Object object) {
            if (string == null || string.isBlank() || string3 == null || string3.isBlank()) {
                ((Logger)Manager.of(Logger.class)).fine(Config.class, "Ignoring invalid config parameter '{}:{}={}'", new Object[]{string, string3, object});
                return Data.empty();
            }
            Data data = Data.of((Object)object);
            Map<String, Tuples.Tuple<Data, Tuples.Tuple<Callback<Tuples.Tuple<String, Data>, Config>, Parameter>>> map = this.store;
            synchronized (map) {
                String string4 = Implementation.implodeName((String)string, (String)string3);
                Tuples.Tuple tuple = this.store.computeIfAbsent(string4, string2 -> new Tuples.Tuple(null, (Object)new Tuples.Tuple(null, (Object)new Parameter(string3.toLowerCase(Locale.ROOT).replace('_', '.')).optional(true))));
                if (((Parameter)((Tuples.Tuple)tuple.b).b).format().equals("json") && data.isString()) {
                    data = Json.decode((String)data.asString());
                }
                if (!((Parameter)((Tuples.Tuple)tuple.b).b).validate(data)) {
                    throw new IllegalArgumentException("Invalid value for parameter " + string4);
                }
                Data data2 = (Data)tuple.a;
                tuple.a = data;
                if (((Tuples.Tuple)tuple.b).a != null) {
                    ((Callback)((Tuples.Tuple)tuple.b).a).trigger((Object)Tuples.Tuple.of((Object)string4, (Object)data));
                }
                return data2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Data remove(String string, String string2) {
            Objects.requireNonNull(string);
            Objects.requireNonNull(string2);
            Map<String, Tuples.Tuple<Data, Tuples.Tuple<Callback<Tuples.Tuple<String, Data>, Config>, Parameter>>> map = this.store;
            synchronized (map) {
                String string3 = Implementation.implodeName((String)string, (String)string2);
                Tuples.Tuple<Data, Tuples.Tuple<Callback<Tuples.Tuple<String, Data>, Config>, Parameter>> tuple = this.store.remove(string3);
                if (tuple == null) {
                    return null;
                }
                if (((Tuples.Tuple)tuple.b).a != null) {
                    ((Callback)((Tuples.Tuple)tuple.b).a).trigger((Object)Tuples.Tuple.of((Object)string3, null));
                }
                return (Data)tuple.a;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void watch(String string, String string2, Functions.BiConsumer<String, Data> biConsumer) {
            Objects.requireNonNull(string);
            Objects.requireNonNull(string2);
            String string3 = Implementation.implodeName((String)string, (String)string2);
            Tuples.Tuple tuple2 = null;
            Map<String, Tuples.Tuple<Data, Tuples.Tuple<Callback<Tuples.Tuple<String, Data>, Config>, Parameter>>> map = this.store;
            synchronized (map) {
                tuple2 = this.store.get(string3);
                if (tuple2 == null) {
                    tuple2 = new Tuples.Tuple(null, (Object)new Tuples.Tuple((Object)new Callback(() -> (Config)Manager.of(Config.class)), (Object)new Parameter(string2.toLowerCase(Locale.ROOT).replace('_', '.'))));
                    this.store.put(string3, (Tuples.Tuple<Data, Tuples.Tuple<Callback<Tuples.Tuple<String, Data>, Config>, Parameter>>)tuple2);
                } else if (((Tuples.Tuple)tuple2.b).a == null) {
                    ((Tuples.Tuple)tuple2.b).a = new Callback(() -> (Config)Manager.of(Config.class));
                }
            }
            ((Callback)((Tuples.Tuple)tuple2.b).a).then((tuple, config) -> biConsumer.accept((Object)((String)tuple.a), (Object)((Data)tuple.b)));
            ((Callback)((Tuples.Tuple)tuple2.b).a).trigger((Object)Tuples.Tuple.of((Object)string3, (Object)((Data)tuple2.a)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, Data> all(String string) {
            HashMap<String, Data> hashMap = new HashMap<String, Data>();
            Map<String, Tuples.Tuple<Data, Tuples.Tuple<Callback<Tuples.Tuple<String, Data>, Config>, Parameter>>> map = this.store;
            synchronized (map) {
                String string2 = Implementation.sanitize((String)string) + ":";
                for (Map.Entry<String, Tuples.Tuple<Data, Tuples.Tuple<Callback<Tuples.Tuple<String, Data>, Config>, Parameter>>> entry : this.store.entrySet()) {
                    if (!entry.getKey().startsWith(string2)) continue;
                    hashMap.put(((Parameter)((Tuples.Tuple)entry.getValue().b).b).name(), (Data)entry.getValue().a);
                }
                return hashMap;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, Map<String, Data>> all() {
            HashMap<String, Map<String, Data>> hashMap = new HashMap<String, Map<String, Data>>();
            Map<String, Tuples.Tuple<Data, Tuples.Tuple<Callback<Tuples.Tuple<String, Data>, Config>, Parameter>>> map = this.store;
            synchronized (map) {
                for (Map.Entry<String, Tuples.Tuple<Data, Tuples.Tuple<Callback<Tuples.Tuple<String, Data>, Config>, Parameter>>> entry : this.store.entrySet()) {
                    Tuples.Tuple tuple = Implementation.explodeName((String)entry.getKey());
                    hashMap.computeIfAbsent((String)tuple.a, string -> new HashMap()).put((String)tuple.b, (Data)entry.getValue().a);
                }
            }
            return hashMap;
        }
    }
}

