/*
 * Decompiled with CFR 0.152.
 */
package aeonics.manager.impl;

import aeonics.data.Data;
import aeonics.entity.Probe;
import aeonics.manager.Executor;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.template.Template;
import aeonics.util.Functions;
import aeonics.util.Hardware;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;

public class DefaultExecutor
extends Manager<Executor> {
    protected Class<? extends Implementation> defaultTarget() {
        return Implementation.class;
    }

    protected Supplier<? extends Implementation> defaultCreator() {
        return () -> new Implementation();
    }

    public Template<? extends Executor> template() {
        return super.template().summary("Default runtime").description("Manages the execution of all the tasks in the system. This manager treats I/O operations as normal tasks.").onCreate((data, executor) -> {
            if (!(executor instanceof Implementation)) {
                return;
            }
            Implementation implementation = (Implementation)((Object)executor);
            ((Probe.Type)new Probe(){}.template().summary("Tasks").description("This probe returns metrics (submitted: the cumulated number of tasks that have been scheduled for execution; completed: the cumulated number of tasts that completed successfully or not; errors: the cumulated number of tasks that failed; time: the cumulated execution time in nanoseconds; pending: the current number of tasks that are pending; size: the current number of executor threads) about the different execution groups (normal, priority, background, io).").create()).source(() -> Data.map().put("normal", (Object)implementation.normal.metrics()).put("priority", (Object)implementation.priority.metrics()).put("background", (Object)implementation.background.metrics()).put("io", (Object)Data.map().put("size", (Object)0).put("submitted", (Object)0).put("completed", (Object)0).put("pending", (Object)0).put("errors", (Object)0).put("time", (Object)0))).name("tasks");
        });
    }

    private static class Implementation
    extends Executor {
        private static ThreadGroup group = new ThreadGroup("aeonics");
        private static ThreadGroup priority_group = new ThreadGroup(group, group.getName() + " priority");
        private static ThreadGroup normal_group = new ThreadGroup(group, group.getName() + " normal");
        private static ThreadGroup background_group = new ThreadGroup(group, group.getName() + " background");
        private static Thread.UncaughtExceptionHandler fatal = (thread, throwable) -> {
            try {
                ((Logger)Manager.of(Logger.class)).severe(thread.getName(), throwable);
            }
            catch (Throwable throwable2) {
                throwable.printStackTrace();
                throwable2.printStackTrace();
            }
        };
        private MonitoredThreadPool priority = MonitoredThreadPool.single();
        private MonitoredThreadPool normal = MonitoredThreadPool.fixed((int)Math.ceil(Hardware.CPU.limit()));
        private MonitoredThreadPool background = MonitoredThreadPool.cached();

        private Implementation() {
        }

        public <T> Executor.Task<T> priority(Functions.Supplier<T> supplier) {
            return Implementation.sync(supplier, (java.util.concurrent.Executor)this.priority);
        }

        public <T> Executor.Task<T> priorityResolved(T t) {
            return Implementation.completed(t, (java.util.concurrent.Executor)this.priority);
        }

        public <T> Executor.Task<T> priorityPending() {
            return Implementation.pending((java.util.concurrent.Executor)this.priority);
        }

        public Executor.Task<Void> priorityFailed(Throwable throwable) {
            return Implementation.failed((Throwable)throwable, (java.util.concurrent.Executor)this.priority);
        }

        public Executor.Task<Void> priority(List<Executor.Task<?>> list) {
            return Implementation.all(list, (java.util.concurrent.Executor)this.priority);
        }

        public boolean isPriority(Thread thread) {
            return thread != null && thread.getThreadGroup().equals(priority_group);
        }

        public <T> Executor.Task<T> normal(Functions.Supplier<T> supplier) {
            return Implementation.async(supplier, (java.util.concurrent.Executor)this.normal);
        }

        public <T> Executor.Task<T> normalResolved(T t) {
            return Implementation.completed(t, (java.util.concurrent.Executor)this.normal);
        }

        public <T> Executor.Task<T> normalPending() {
            return Implementation.pending((java.util.concurrent.Executor)this.normal);
        }

        public Executor.Task<Void> normalFailed(Throwable throwable) {
            return Implementation.failed((Throwable)throwable, (java.util.concurrent.Executor)this.normal);
        }

        public Executor.Task<Void> normal(List<Executor.Task<?>> list) {
            return Implementation.all(list, (java.util.concurrent.Executor)this.normal);
        }

        public boolean isNormal(Thread thread) {
            return thread != null && thread.getThreadGroup().equals(normal_group);
        }

        public <T> Executor.Task<T> background(Functions.Supplier<T> supplier) {
            return Implementation.sync(supplier, (java.util.concurrent.Executor)this.background);
        }

        public <T> Executor.Task<T> backgroundResolved(T t) {
            return Implementation.completed(t, (java.util.concurrent.Executor)this.background);
        }

        public <T> Executor.Task<T> backgroundPending() {
            return Implementation.pending((java.util.concurrent.Executor)this.background);
        }

        public Executor.Task<Void> backgroundFailed(Throwable throwable) {
            return Implementation.failed((Throwable)throwable, (java.util.concurrent.Executor)this.background);
        }

        public Executor.Task<Void> background(List<Executor.Task<?>> list) {
            return Implementation.all(list, (java.util.concurrent.Executor)this.background);
        }

        public boolean isBackground(Thread thread) {
            return thread != null && thread.getThreadGroup().equals(background_group);
        }

        public <T> Executor.Task<T> io(Functions.Supplier<T> supplier) {
            return this.normal(supplier);
        }

        public <T> Executor.Task<T> ioResolved(T t) {
            return this.normalResolved(t);
        }

        public <T> Executor.Task<T> ioPending() {
            return this.normalPending();
        }

        public Executor.Task<Void> ioFailed(Throwable throwable) {
            return this.normalFailed(throwable);
        }

        public Executor.Task<Void> io(List<Executor.Task<?>> list) {
            return this.normal(list);
        }

        public boolean isIo(Thread thread) {
            return false;
        }

        private static class MonitoredThreadPool
        extends ThreadPoolExecutor {
            private LongAdder errors = new LongAdder();
            private LongAdder time = new LongAdder();
            private static AtomicInteger counter = new AtomicInteger(0);

            public static MonitoredThreadPool single() {
                return new MonitoredThreadPool(1, 1, 0L, new LinkedBlockingQueue<Runnable>(), runnable -> {
                    MonitoredThread monitoredThread = new MonitoredThread(priority_group, runnable);
                    monitoredThread.setUncaughtExceptionHandler(fatal);
                    monitoredThread.setDaemon(false);
                    monitoredThread.setPriority(10);
                    monitoredThread.setName(group.getName() + " #" + counter.incrementAndGet() + " > Priority");
                    return monitoredThread;
                });
            }

            public static MonitoredThreadPool fixed(int n) {
                return new MonitoredThreadPool(n, n, 0L, new LinkedBlockingQueue<Runnable>(), runnable -> {
                    MonitoredThread monitoredThread = new MonitoredThread(normal_group, runnable);
                    monitoredThread.setUncaughtExceptionHandler(fatal);
                    monitoredThread.setDaemon(false);
                    monitoredThread.setPriority(5);
                    monitoredThread.setName(group.getName() + " #" + counter.incrementAndGet() + " > Normal");
                    return monitoredThread;
                });
            }

            public static MonitoredThreadPool cached() {
                return new MonitoredThreadPool(0, Integer.MAX_VALUE, 60000L, new SynchronousQueue<Runnable>(), runnable -> {
                    MonitoredThread monitoredThread = new MonitoredThread(background_group, runnable);
                    monitoredThread.setUncaughtExceptionHandler(fatal);
                    monitoredThread.setDaemon(true);
                    monitoredThread.setPriority(1);
                    monitoredThread.setName(group.getName() + " #" + counter.incrementAndGet() + " > Background");
                    return monitoredThread;
                });
            }

            public MonitoredThreadPool(int n, int n2, long l, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
                super(n, n2, l, TimeUnit.MILLISECONDS, blockingQueue, threadFactory);
            }

            @Override
            public void beforeExecute(Thread thread, Runnable runnable) {
                ((MonitoredThread)thread).start = System.nanoTime();
            }

            @Override
            public void afterExecute(Runnable runnable, Throwable throwable) {
                if (throwable != null) {
                    this.errors.increment();
                }
                this.time.add(System.nanoTime() - ((MonitoredThread)Thread.currentThread()).start);
            }

            public Data metrics() {
                return Data.map().put("submitted", (Object)this.getTaskCount()).put("completed", (Object)this.getCompletedTaskCount()).put("errors", (Object)this.errors.longValue()).put("time", (Object)this.time.longValue()).put("pending", (Object)this.getQueue().size()).put("size", (Object)this.getPoolSize());
            }
        }

        private static class MonitoredThread
        extends Thread {
            private volatile long start = 0L;

            public MonitoredThread(ThreadGroup threadGroup, Runnable runnable) {
                super(threadGroup, runnable);
            }
        }
    }
}

