/*
 * Decompiled with CFR 0.152.
 */
package aeonics.manager.impl;

import aeonics.data.Data;
import aeonics.entity.Entity;
import aeonics.entity.Message;
import aeonics.entity.Probe;
import aeonics.entity.Registry;
import aeonics.entity.Scheduled;
import aeonics.entity.Step;
import aeonics.entity.security.User;
import aeonics.manager.Config;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.manager.Monitor;
import aeonics.template.Channel;
import aeonics.template.Factory;
import aeonics.template.Parameter;
import aeonics.template.Template;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;

public class DefaultMonitor
extends Manager<Monitor> {
    private static Scheduled.Type origin = (Scheduled.Type)((Step.Type)new Scheduled(){}.template().icon("monitoring").output(new Channel("metrics").summary("Metrics").description("System metrics")).output(new Channel("probes").summary("Probes").description("System probes")).summary("Monitoring").description("This origin entity collects monioring metrics at the interval defined by the monitor manager and feeds them as data in the system.").create(Data.map().put("id", (Object)"10000000-2000000000000000").put("parameters", (Object)Data.map().put("rule", (Object)("RRULE:FREQ=SECONDLY;INTERVAL=" + ((Config)Manager.of(Config.class)).get(Monitor.class, "window").asLong() / 1000L))))).name("Monitoring").internal(true);

    public static void register() {
    }

    public static Step.Origin.Type origin() {
        return origin;
    }

    protected Class<? extends Implementation> defaultTarget() {
        return Implementation.class;
    }

    protected Supplier<? extends Implementation> defaultCreator() {
        return () -> new Implementation();
    }

    public Template<? extends Monitor> template() {
        return super.template().summary("Windowed monitor").description("This monitor will keep track of the counters and accumulated values for a specified amount of time. Reported values are always the last completed window, not the current one, and include a \"_count\" property for the number of occurences and a \"_total\" property for the accumulated value.").config(Monitor.class, new Parameter("window").summary("Time window").description("The amount of time in milliseconds to keep track of metrics and then reset to 0. If this value is modified, the window will be applied after the end of the current window.").rule(Parameter.Rule.DIGIT).format("number").optional(true).defaultValue((Object)60000)).config(Monitor.class, new Parameter("enabled").summary("Enable monitoring").description("Whether or not the monitoring should be enabled. If set to false, then all monitoring requests are ignored.").rule(Parameter.Rule.BOOLEAN).format("boolean").optional(true).defaultValue((Object)false));
    }

    static {
        origin.task(zonedDateTime -> {
            Data data;
            if (!((Config)Manager.of(Config.class)).get(Monitor.class, "enabled").asBool()) {
                return;
            }
            try {
                data = ((Monitor)Manager.of(Monitor.class)).report();
                if (!data.isEmpty()) {
                    origin.produce(new Message("metrics").user(User.SYSTEM.id()).content(data), "metrics");
                }
            }
            catch (Exception exception) {
                ((Logger)Manager.of(Logger.class)).warning(Monitor.class, (Throwable)exception);
            }
            try {
                data = Data.map();
                for (Probe.Type type : Registry.of(Probe.class)) {
                    data.put(type.name(), (Object)type.report());
                }
                if (!data.isEmpty()) {
                    origin.produce(new Message("probes").user(User.SYSTEM.id()).content(data), "probes");
                }
            }
            catch (Exception exception) {
                ((Logger)Manager.of(Logger.class)).warning(Monitor.class, (Throwable)exception);
            }
        });
    }

    private static class Implementation
    extends Monitor {
        private static final String FROM = "_from";
        private static final String TO = "_to";
        private static final String COUNT = "_count";
        private static final String TOTAL = "_total";
        private boolean enabled = false;
        private long window = 60000L;
        private volatile long from = 0L;
        private volatile long to = 0L;
        private volatile boolean clean = false;
        private volatile Data past = null;
        private volatile Data current = null;

        private Implementation() {
        }

        public void add(String string, String string2, String string3, String string4, long l) {
            if (!this.enabled) {
                return;
            }
            Objects.requireNonNull(string);
            Objects.requireNonNull(string2);
            Objects.requireNonNull(string3);
            Objects.requireNonNull(string4);
            Data data = this.getOrReset();
            Data data2 = this.getOrCreate(data, string, false);
            Data data3 = this.getOrCreate(data2, string2, false);
            Data data4 = this.getOrCreate(data3, string3, false);
            Data data5 = this.getOrCreate(data4, string4, true);
            ((LongAdder)data5.get(COUNT).get()).increment();
            if (l != 0L) {
                ((LongAdder)data5.get(TOTAL).get()).add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Data getOrCreate(Data data, String string, boolean bl) {
            Data data2 = data.get(string);
            if (!data2.isMap()) {
                Data data3 = data;
                synchronized (data3) {
                    data2 = data.get(string);
                    if (!data2.isMap()) {
                        data2 = Data.map();
                        if (bl) {
                            data2.put(COUNT, (Object)new LongAdder()).put(TOTAL, (Object)new LongAdder());
                        }
                        data.put(string, (Object)data2);
                    }
                }
            }
            return data2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Data report(String string, String string2, String string3, String string4) {
            Object object;
            this.getOrReset();
            Data data = this.past;
            if (!this.clean) {
                if (data == null) {
                    return Data.map();
                }
                object = this;
                synchronized (object) {
                    if (!this.clean) {
                        this.cleanData(data);
                        this.clean = true;
                    }
                }
            }
            if (string == null && string2 == null && string3 == null && string4 == null) {
                return data;
            }
            object = Data.map();
            for (Map.Entry entry : data.entrySet()) {
                if (((String)entry.getKey()).equals(FROM) || ((String)entry.getKey()).equals(TO)) {
                    object.put((String)entry.getKey(), entry.getValue());
                    continue;
                }
                if (string != null && (!string.equals(entry.getKey()) || !((Data)entry.getValue()).isMap())) continue;
                Data data2 = Data.map();
                for (Map.Entry entry2 : ((Data)entry.getValue()).entrySet()) {
                    if (string2 != null && (!string2.equals(entry2.getKey()) || !((Data)entry2.getValue()).isMap())) continue;
                    Data data3 = Data.map();
                    for (Map.Entry entry3 : ((Data)entry2.getValue()).entrySet()) {
                        if (string3 != null && (!string3.equals(entry3.getKey()) || !((Data)entry3.getValue()).isMap())) continue;
                        Data data4 = Data.map();
                        for (Map.Entry entry4 : ((Data)entry3.getValue()).entrySet()) {
                            if (!((String)entry4.getKey()).equals(COUNT) && !((String)entry4.getKey()).equals(TOTAL)) continue;
                            data4.put((String)entry4.getKey(), entry4.getValue());
                        }
                        data3.put((String)entry3.getKey(), (Object)data4);
                    }
                    data2.put((String)entry2.getKey(), (Object)data3);
                }
                object.put((String)entry.getKey(), (Object)data2);
            }
            return object;
        }

        private void cleanData(Data data) {
            for (Map.Entry entry : data.entrySet()) {
                if (((Data)entry.getValue()).isMap()) {
                    this.cleanData((Data)entry.getValue());
                    continue;
                }
                if (!((Data)entry.getValue()).is(LongAdder.class)) continue;
                entry.setValue(Data.of((Object)((LongAdder)((Data)entry.getValue()).get()).longValue()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Data getOrReset() {
            long l = System.currentTimeMillis();
            if (this.to < l || this.current == null) {
                Implementation implementation = this;
                synchronized (implementation) {
                    if (this.to < l || this.current == null) {
                        this.from = l - l % this.window;
                        this.to = this.from + this.window;
                        this.past = this.current;
                        this.current = Data.map().put(FROM, (Object)this.from).put(TO, (Object)this.to);
                        this.clean = false;
                    }
                }
            }
            return this.current;
        }

        public void config(String string, Data data) {
            if (Config.implodeName(Monitor.class, (String)"window").equals(string)) {
                try {
                    Factory.update((Entity)origin, (Data)Data.map().put("rule", (Object)("RRULE:FREQ=SECONDLY;INTERVAL=" + data.asLong() / 1000L)));
                    this.window = data.asInt();
                }
                catch (Exception exception) {
                    ((Logger)Manager.of(Logger.class)).severe(Monitor.class, "Could not set monitor window to {}. Current value {} is unchanged.", new Object[]{data, this.window});
                }
            } else if (Config.implodeName(Monitor.class, (String)"enabled").equals(string)) {
                try {
                    this.enabled = data.asBool();
                }
                catch (Exception exception) {
                    ((Logger)Manager.of(Logger.class)).severe(Monitor.class, "Could not set monitor enabled state to {}. Current value {} is unchanged.", new Object[]{data, this.enabled});
                }
            }
        }
    }
}

