/*
 * Decompiled with CFR 0.152.
 */
package aeonics.manager.impl;

import aeonics.manager.Executor;
import aeonics.manager.Lifecycle;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.manager.Timeout;
import aeonics.template.Template;
import aeonics.util.Callback;
import java.io.Closeable;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;

public class DefaultTimeout
extends Manager<Timeout> {
    protected Class<? extends Implementation> defaultTarget() {
        return Implementation.class;
    }

    protected Supplier<? extends Implementation> defaultCreator() {
        return () -> new Implementation();
    }

    public Template<? extends Timeout> template() {
        return super.template().summary("Non-blocking timeout manager").description("This timeout manager will keep track of all trackers in a non-blocking efficient manner and will deferprocessing of expired elements to the Execution manager.").onCreate((data, timeout) -> {
            if (((Lifecycle)Manager.of(Lifecycle.class)).phase() == Lifecycle.Phase.RUN) {
                ((Implementation)timeout).task = ((Implementation)timeout).task();
            } else {
                Lifecycle.before((Lifecycle.Phase)Lifecycle.Phase.RUN, (Callback.Once)Callback.once(() -> {
                    ((Implementation)timeout).task = ((Implementation)timeout).task();
                }));
            }
        });
    }

    private static class Implementation
    extends Timeout
    implements Closeable {
        private final Object locker = new Object();
        private Queue<Timeout.Tracker<?>> targets = new ConcurrentLinkedQueue();
        private Executor.Task<Void> task = null;

        private Implementation() {
        }

        public <T> void watch(Timeout.Tracker<T> tracker) {
            if (tracker == null) {
                return;
            }
            this.targets.add(tracker);
            this.refresh();
        }

        public <T> void remove(Timeout.Tracker<T> tracker) {
            if (tracker != null) {
                this.targets.remove(tracker);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh() {
            Object object = this.locker;
            synchronized (object) {
                this.locker.notifyAll();
            }
        }

        @Override
        public void close() {
            if (this.task != null) {
                this.task.cancel();
            }
        }

        private Executor.Task<Void> task() {
            return ((Executor)Manager.of(Executor.class)).background(() -> {
                Thread.currentThread().setName(Thread.currentThread().getName() + " :: Timeout Manager");
                while (true) {
                    long l;
                    Object object;
                    long l2 = -1L;
                    Iterator iterator = this.targets.iterator();
                    while (iterator.hasNext()) {
                        object = (Timeout.Tracker)iterator.next();
                        if (object == null) {
                            iterator.remove();
                            continue;
                        }
                        try {
                            l = object.delay();
                            if (l < 0L) {
                                iterator.remove();
                                continue;
                            }
                            if (l > 0L) {
                                if (l2 != -1L && System.currentTimeMillis() + l >= l2) continue;
                                l2 = System.currentTimeMillis() + l;
                                continue;
                            }
                            Object object2 = object.target();
                            if (object2 != null) {
                                ((Executor)Manager.of(Executor.class)).normal(() -> Implementation.lambda$task$0((Timeout.Tracker)object, object2));
                            }
                            iterator.remove();
                        }
                        catch (Exception exception) {
                            ((Logger)Manager.of(Logger.class)).fine(Timeout.class, (Throwable)exception);
                            iterator.remove();
                        }
                    }
                    try {
                        object = this.locker;
                        synchronized (object) {
                            if (l2 < 0L) {
                                ((Logger)Manager.of(Logger.class)).finest(Timeout.class, (Object)"No future elements to watch. Sleeping until further notice.");
                                this.locker.wait();
                            } else {
                                l = l2 - System.currentTimeMillis();
                                if (l <= 0L) {
                                    continue;
                                }
                                ((Logger)Manager.of(Logger.class)).finest(Timeout.class, "Next timeout element is in {}ms. Sleeping.", new Object[]{l});
                                this.locker.wait(l);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            });
        }

        private static /* synthetic */ void lambda$task$0(Timeout.Tracker tracker, Object object) throws Exception {
            tracker.onExpire().trigger(object);
        }
    }
}

