/*
 * Decompiled with CFR 0.152.
 */
package aeonics.data;

import aeonics.data.Data;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class DataList
implements Data {
    private LinkedList<Data> source = new LinkedList();

    public DataList(Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        for (Object obj : collection) {
            this.source.add(Data.of(obj));
        }
    }

    public DataList(Set<?> set) {
        if (set == null || set.isEmpty()) {
            return;
        }
        for (Object obj : set) {
            this.source.add(Data.of(obj));
        }
    }

    public DataList(Enumeration<?> enumeration) {
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            this.source.add(Data.of(enumeration.nextElement()));
        }
    }

    public DataList(Iterable<?> iterable) {
        if (iterable == null) {
            return;
        }
        for (Object obj : iterable) {
            this.source.add(Data.of(obj));
        }
    }

    public DataList(Iterator<?> iterator) {
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            this.source.add(Data.of(iterator.next()));
        }
    }

    public DataList(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.source.add(Data.of(objectArray[i]));
        }
    }

    public static DataList fromPrimitiveArray(Object object) {
        ArrayList<Serializable> arrayList;
        block10: {
            Class<?> clazz;
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block9: {
                                        if (object == null || !object.getClass().isArray() || !object.getClass().getComponentType().isPrimitive()) {
                                            return new DataList((Collection)null);
                                        }
                                        arrayList = new ArrayList<Serializable>();
                                        clazz = object.getClass().getComponentType();
                                        if (clazz != Byte.TYPE) break block9;
                                        for (byte by : (byte[])object) {
                                            arrayList.add(Byte.valueOf(by));
                                        }
                                        break block10;
                                    }
                                    if (clazz != Short.TYPE) break block11;
                                    for (short s : (short[])object) {
                                        arrayList.add(Short.valueOf(s));
                                    }
                                    break block10;
                                }
                                if (clazz != Integer.TYPE) break block12;
                                for (int n : (int[])object) {
                                    arrayList.add(Integer.valueOf(n));
                                }
                                break block10;
                            }
                            if (clazz != Long.TYPE) break block13;
                            for (long l : (long[])object) {
                                arrayList.add(Long.valueOf(l));
                            }
                            break block10;
                        }
                        if (clazz != Float.TYPE) break block14;
                        for (float f : (float[])object) {
                            arrayList.add(Float.valueOf(f));
                        }
                        break block10;
                    }
                    if (clazz != Double.TYPE) break block15;
                    for (double d : (double[])object) {
                        arrayList.add(Double.valueOf(d));
                    }
                    break block10;
                }
                if (clazz != Character.TYPE) break block16;
                for (char c : (char[])object) {
                    arrayList.add(Character.valueOf(c));
                }
                break block10;
            }
            if (clazz != Boolean.TYPE) break block10;
            for (boolean bl : (boolean[])object) {
                arrayList.add(Boolean.valueOf(bl));
            }
        }
        return new DataList((Collection<?>)arrayList);
    }

    @Override
    public Iterator<Data> iterator() {
        return this.source.iterator();
    }

    @Override
    public Iterable<Map.Entry<String, Data>> entrySet() {
        return Collections.emptySet();
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public boolean isBool() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean is(Class<?> clazz) {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    @Override
    public Data get(String string) {
        return this.get(Integer.parseInt(string));
    }

    @Override
    public Data get(int n) {
        if (n < 0 || n >= this.source.size()) {
            return Data.of(null);
        }
        return this.source.get(n);
    }

    @Override
    public <T> T get() {
        return (T)this;
    }

    @Override
    public boolean containsKey(String string) {
        try {
            int n = Integer.parseInt(string);
            return n >= 0 && n < this.source.size();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void clear() {
        this.source.clear();
    }

    @Override
    public int size() {
        return this.source.size();
    }

    @Override
    public Data remove(String string) {
        return this.remove(Integer.parseInt(string));
    }

    @Override
    public Data remove(int n) {
        return this.source.remove(n);
    }

    @Override
    public Data remove(Data data) {
        int n = this.source.indexOf(data);
        if (n >= 0) {
            return this.source.remove(n);
        }
        return null;
    }

    @Override
    public void removeIf(Predicate<Data> predicate) {
        this.source.removeIf(predicate);
    }

    @Override
    public Data add(Object object) {
        if (object instanceof Data) {
            this.source.add((Data)object);
        } else {
            this.source.add(Data.of(object));
        }
        return this;
    }

    @Override
    public Data add(Object ... objectArray) {
        for (Object object : objectArray) {
            this.add(object);
        }
        return this;
    }

    @Override
    public Data put(String string, Object object) {
        return this.set(Integer.parseInt(string), object);
    }

    @Override
    public Data set(int n, Object object) {
        if (object instanceof Data) {
            this.source.set(n, (Data)object);
        } else {
            this.source.set(n, Data.of(object));
        }
        return this;
    }

    @Override
    public Data set(Object object) {
        return this.add(object);
    }

    @Override
    public boolean asBool() {
        return !this.source.isEmpty();
    }

    @Override
    public Number asNumber() {
        return this.source.size();
    }

    @Override
    public String asString() {
        return this.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("[");
        boolean bl = true;
        for (Data data : this.source) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            if (data == null) {
                stringBuilder.append("null");
                continue;
            }
            data.toString(stringBuilder);
        }
        stringBuilder.append("]");
    }

    public boolean equals(Object linkedList) {
        if (linkedList == this) {
            return true;
        }
        if (linkedList instanceof DataList) {
            linkedList = ((DataList)((Object)linkedList)).source;
        } else if (linkedList instanceof Data) {
            linkedList = ((Data)((Object)linkedList)).get();
        }
        if (linkedList == this.source) {
            return true;
        }
        if (linkedList == null) {
            return false;
        }
        if (linkedList instanceof Collection && ((Collection)linkedList).size() != this.source.size()) {
            return false;
        }
        if (!(linkedList instanceof Iterable)) {
            return false;
        }
        Iterator iterator = ((Iterable)linkedList).iterator();
        Iterator<Data> iterator2 = this.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            if (iterator2.next().equals(iterator.next())) continue;
            return false;
        }
        return !iterator.hasNext() && !iterator2.hasNext();
    }

    @Override
    public Data clone() {
        DataList dataList = new DataList((Collection)null);
        this.cloneTo(dataList);
        return dataList;
    }

    @Override
    public void cloneTo(Data data) {
        if (!(data instanceof DataList)) {
            throw new IllegalArgumentException("Clone failed. Incompatible receiving data type.");
        }
        data.clear();
        for (Data data2 : this) {
            data.add((Object)data2.clone());
        }
    }
}

