/*
 * Decompiled with CFR 0.152.
 */
package aeonics.entity;

import aeonics.data.Data;
import aeonics.entity.Entity;
import aeonics.entity.Message;
import aeonics.entity.Step;
import aeonics.entity.security.User;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.template.Channel;
import aeonics.template.Template;
import aeonics.util.Snapshotable;
import java.util.Arrays;
import java.util.stream.Collectors;

public class Debug {
    private static final _Debug DEBUG = (_Debug)((Entity)((Entity)((Step.Type)((Template)((Template)((Template)((Step.Template)((Step.Template)new Step.Origin(){}.target(_Debug.class).creator(() -> new _Debug()).template().cast()).icon("bug_report")).output((Channel)((Channel)new Channel("data").summary("Debug")).description("Debug information sent from the system"))).summary("Debug")).description("This data origin is used as a common central debug point.")).create(Data.map().put("id", "10000000-1400000000000000"))).name("Debug")).internal(true)).snapshotMode(Snapshotable.SnapshotMode.UPDATE);

    private Debug() {
    }

    public static void register() {
    }

    public static void debug(String string, Object ... objectArray) {
        Message message = new Message(string);
        message.user(User.SYSTEM.id());
        message.content(Data.map().put("stack", Debug.getStackTrace()).put("values", objectArray));
        DEBUG.produce(message, "data");
    }

    public static void values(String string, Object ... objectArray) {
        Message message = new Message(string);
        message.user(User.SYSTEM.id());
        message.content(Data.map().put("values", objectArray));
        DEBUG.produce(message, "data");
    }

    public static void stacktrace(String string) {
        Message message = new Message(string);
        message.user(User.SYSTEM.id());
        message.content(Data.map().put("stack", Debug.getStackTrace()));
        DEBUG.produce(message, "data");
    }

    private static Data getStackTrace() {
        int n = Manager.of(Logger.class).level();
        return Data.of(Arrays.stream(new Exception().fillInStackTrace().getStackTrace()).filter(stackTraceElement -> {
            if (stackTraceElement.getClassName().equals(Debug.class.getName())) {
                return false;
            }
            return n <= -1 || (stackTraceElement.getModuleName() == null || !stackTraceElement.getModuleName().startsWith("java.")) && !stackTraceElement.getClassName().startsWith("java.") && !stackTraceElement.getClassName().startsWith("javax.") && !stackTraceElement.getClassName().startsWith("jdk.") && !stackTraceElement.getClassName().startsWith("sun.") && !stackTraceElement.getClassName().startsWith("aeonics.");
        }).collect(Collectors.toList()));
    }

    private static final class _Debug
    extends Step.Origin.Type {
        private _Debug() {
        }

        @Override
        public void produce(Message message, String string) {
            if (message == null) {
                return;
            }
            if (!this.started()) {
                this.start();
            }
            if (message.metadata().asBool("discarded") || message.metadata().asBool("debug")) {
                return;
            }
            message.metadata().put("debug", true);
            super.produce(message, string);
        }
    }
}

