/*
 * Decompiled with CFR 0.152.
 */
package aeonics.entity;

import aeonics.data.Data;
import aeonics.manager.Network;
import aeonics.util.Exportable;
import java.lang.ref.WeakReference;
import java.util.Objects;

public class Message
implements Exportable {
    private String key = "";
    private String user = null;
    private Data content = Data.map();
    private Data metadata = Data.map();
    private WeakReference<Network.Connection> connection = null;

    public String key() {
        return this.key;
    }

    public Message key(String string) {
        this.key = Objects.requireNonNullElse(string, "");
        return this;
    }

    public String user() {
        return this.user;
    }

    public Message user(String string) {
        this.user = string;
        return this;
    }

    public Data content() {
        return this.content;
    }

    public Message content(Data data) {
        this.content = Objects.requireNonNullElseGet(data, Data::empty);
        return this;
    }

    public Data metadata() {
        return this.metadata;
    }

    public Network.Connection connection() {
        return this.connection == null ? null : (Network.Connection)this.connection.get();
    }

    public Message connection(Network.Connection connection) {
        this.connection = new WeakReference<Network.Connection>(connection);
        return this;
    }

    public Message(String string) {
        this.key(string);
        this.metadata().put("ttl", 20);
    }

    private Message(Message message) {
        this(message.key());
        this.user(message.user());
        this.connection(this.connection());
        this.content(message.content().clone());
        message.metadata().cloneTo(this.metadata());
    }

    private Message(Data data) {
        this(data.asString("key"));
        this.user(data.isNull("user") ? null : data.asString("user"));
        this.content(data.get("content"));
        data.get("metadata").cloneTo(this.metadata());
    }

    public static Message of(Data data) {
        return new Message(data);
    }

    public Message clone() {
        return new Message(this);
    }

    @Override
    public Data export() {
        return Data.map().put("key", this.key()).put("user", this.user()).put("content", this.content()).put("metadata", this.metadata());
    }

    public String toString() {
        return this.export().toString();
    }
}

