/*
 * Decompiled with CFR 0.152.
 */
package aeonics.entity;

import aeonics.data.Data;
import aeonics.entity.Entity;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.template.Item;
import aeonics.template.Template;
import aeonics.util.Functions;
import aeonics.util.Snapshotable;
import java.util.function.Supplier;

public class Probe
extends Item<Type> {
    @Override
    protected Class<? extends Type> defaultTarget() {
        return Type.class;
    }

    @Override
    protected Supplier<? extends Type> defaultCreator() {
        return Type::new;
    }

    @Override
    protected Class<? extends Probe> category() {
        return Probe.class;
    }

    @Override
    public Template<? extends Type> template() {
        return ((Template)super.template().summary("Probe")).description("This entity provides probe data.");
    }

    public static class Type
    extends Entity {
        private Functions.Supplier<Data> source;

        public <T extends Type> T source(Functions.Supplier<Data> supplier) {
            this.source = supplier;
            return (T)this;
        }

        public synchronized Data report() {
            if (this.source == null) {
                return Data.map();
            }
            try {
                Data data = this.source.get();
                if (data == null) {
                    return Data.map();
                }
                return data;
            }
            catch (Exception exception) {
                Manager.of(Logger.class).info(Probe.class, (Throwable)exception);
                return Data.map();
            }
        }

        @Override
        public boolean internal() {
            return true;
        }

        @Override
        public Snapshotable.SnapshotMode snapshotMode() {
            return Snapshotable.SnapshotMode.NONE;
        }
    }
}

