/*
 * Decompiled with CFR 0.152.
 */
package aeonics.entity;

import aeonics.entity.Message;
import aeonics.entity.Registry;
import aeonics.entity.Step;
import aeonics.manager.Lifecycle;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.manager.Scheduler;
import aeonics.template.Parameter;
import aeonics.template.Template;
import aeonics.util.Functions;
import aeonics.util.Snapshotable;
import java.time.ZonedDateTime;
import java.util.function.Supplier;

public class Scheduled
extends Step.Origin {
    @Override
    protected Class<? extends Type> defaultTarget() {
        return Type.class;
    }

    @Override
    protected Supplier<? extends Type> defaultCreator() {
        return Type::new;
    }

    @Override
    public Step.Template template() {
        return (Step.Template)((Template)((Template)((Template)((Template)((Template)super.template().icon("alarm")).summary("Scheduled origin")).description("This data origin is triggered automatically at regular interval.")).add((Parameter)((Parameter)((Parameter)new Parameter("rule").summary("Recurring rule")).description("The recurrence is defined by a RFC-5545 RRULE and DTSART string.")).format("text"))).onCreate((data, type) -> {
            ((Type)type).cron = ((Scheduler.Cron.Type)((Scheduler.Cron.Type)((Scheduler.Cron.Type)new Scheduler.Cron(){}.template().create()).task(zonedDateTime -> ((Type)type).runTask((ZonedDateTime)zonedDateTime))).start(ZonedDateTime.now().withNano(0))).rule(data.asString("rule"));
            if (Manager.of(Lifecycle.class).phase() == Lifecycle.Phase.RUN) {
                ((Type)type).start();
            }
        })).onUpdate((data, type) -> {
            if (data.containsKey("rule")) {
                ((Type)type).cron.rule(data.asString("rule"));
                if (Manager.of(Lifecycle.class).phase() == Lifecycle.Phase.RUN) {
                    Manager.of(Scheduler.class).refresh();
                }
            }
        });
    }

    public static class Type
    extends Step.Origin.Type {
        private Functions.Consumer<ZonedDateTime> task = null;
        private Scheduler.Cron.Type cron = null;

        public Type() {
            this.snapshotMode(Snapshotable.SnapshotMode.UPDATE);
        }

        @Override
        public void produce(Message message, String string) {
            super.produce(message, string);
        }

        private void runTask(ZonedDateTime zonedDateTime) {
            if (this.task != null) {
                try {
                    this.task.accept(zonedDateTime);
                }
                catch (Exception exception) {
                    Manager.of(Logger.class).warning(Scheduled.class, (Throwable)exception);
                }
            }
        }

        public Type task(Functions.Consumer<ZonedDateTime> consumer) {
            this.task = consumer;
            return this;
        }

        @Override
        public void start() {
            if (this.cron != null) {
                if (!Registry.of(Scheduler.Cron.class).contains(this.cron.id())) {
                    Registry.add(this.cron);
                }
                Manager.of(Scheduler.class).refresh();
                this.started(true);
            }
        }

        @Override
        public void stop() {
            if (this.cron != null) {
                Registry.of(Scheduler.Cron.class).remove(this.cron.id());
                this.stopped(true);
            }
        }
    }
}

