/*
 * Decompiled with CFR 0.152.
 */
package aeonics.entity.security;

import aeonics.data.Data;
import aeonics.entity.Entity;
import aeonics.entity.security.Group;
import aeonics.entity.security.Role;
import aeonics.entity.security.User;
import aeonics.manager.Config;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.manager.Security;
import aeonics.manager.Vault;
import aeonics.template.Item;
import aeonics.template.Parameter;
import aeonics.template.Relationship;
import aeonics.template.Template;
import aeonics.util.Json;
import aeonics.util.Tuples;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public abstract class Multifactor
extends Item<Type> {
    @Override
    public Template<? extends Type> template() {
        return ((Template)((Template)super.template().add((Relationship)((Relationship)((Relationship)new Relationship("roles").category(Role.class)).summary("Roles")).description("The user roles that this multifactor method applies to."))).add((Relationship)((Relationship)((Relationship)new Relationship("groups").category(Group.class)).summary("Groups")).description("The user groups that this multifactor method applies to."))).onCreate((data, type) -> {
            type.key = data.containsKey("key") ? data.asString("key") : Manager.of(Security.class).randomHash();
        });
    }

    @Override
    protected Class<? extends Multifactor> category() {
        return Multifactor.class;
    }

    public static class TOTP
    extends Multifactor {
        @Override
        protected Class<? extends Type> defaultTarget() {
            return Type.class;
        }

        @Override
        protected Supplier<? extends Type> defaultCreator() {
            return Type::new;
        }

        @Override
        public Template<? extends aeonics.entity.security.Multifactor$Type> template() {
            return ((Template)((Template)((Template)((Template)((Template)super.template().summary("TOTP")).description("Time-based One Time Password implementation.")).config((Parameter)((Parameter)((Parameter)((Parameter)new Parameter("otpperiod").summary("OTP time window")).description("The OTP time window in seconds.")).rule(Parameter.Rule.DIGIT).format("number")).defaultValue(30))).config((Parameter)((Parameter)((Parameter)((Parameter)new Parameter("otpdigits").summary("OTP number of digits")).description("The number of OTP code digits.")).rule(Parameter.Rule.DIGIT).format("number")).defaultValue(6))).config((Parameter)((Parameter)((Parameter)((Parameter)new Parameter("otpalgorithm").summary("OTP algorithm")).description("The name of the hash algorithm to use in OTP.")).values("SHA1").format("select")).defaultValue("SHA1"))).config((Parameter)((Parameter)((Parameter)((Parameter)new Parameter("otpissuer").summary("OTP issuer name")).description("The name of the OTP issuer to be displayed by MFA apps.")).format("text")).defaultValue("Aeonics"));
        }

        public static class Type
        extends aeonics.entity.security.Multifactor$Type {
            private static final char[] BASE32_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".toCharArray();
            private static final int[] REVERSE_BASE32 = new int[]{26, 27, 28, 29, 30, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25};

            @Override
            public void enroll(User.Type type, Data data) {
                if (type == null || type == User.ANONYMOUS || type == User.SYSTEM) {
                    throw new IllegalArgumentException("Invalid user");
                }
                if (this.enrolled(type)) {
                    throw new RuntimeException("Already enrolled");
                }
                if (data == null || !data.isMap() || data.isEmpty("secret")) {
                    throw new IllegalArgumentException("Invalid enrollment data");
                }
                try {
                    Data data2 = Data.map().put("secret", data.asString("secret")).put("period", Manager.of(Config.class).get(this.type(), "otpperiod")).put("digits", Manager.of(Config.class).get(this.type(), "otpdigits")).put("algorithm", Manager.of(Config.class).get(this.type(), "otpalgorithm"));
                    this.privateData(type, data2);
                }
                catch (Exception exception) {
                    Manager.of(Logger.class).info(Multifactor.class, (Throwable)exception);
                    throw new RuntimeException("TOTP generation failed");
                }
            }

            @Override
            public Data generate(User.Type type, Data data) {
                if (type == null || type == User.ANONYMOUS || type == User.SYSTEM) {
                    throw new IllegalArgumentException("Invalid user");
                }
                Data data2 = Data.map().put("secret", Type.randomSecret()).put("period", Manager.of(Config.class).get(this.type(), "otpperiod")).put("digits", Manager.of(Config.class).get(this.type(), "otpdigits")).put("algorithm", Manager.of(Config.class).get(this.type(), "otpalgorithm"));
                return data2.put("url", "otpauth://totp/" + URLEncoder.encode(Manager.of(Config.class).get(this.type(), "otpissuer").asString(), StandardCharsets.UTF_8).replace("+", "%20") + ":" + URLEncoder.encode(type.name(), StandardCharsets.UTF_8).replace("+", "%20") + "?secret=" + data2.asString("secret") + "&issuer=" + URLEncoder.encode(Manager.of(Config.class).get(this.type(), "otpissuer").asString(), StandardCharsets.UTF_8).replace("+", "%20") + "&algorithm=" + data2.asString("algorithm") + "&digits=" + data2.asString("digits") + "&period=" + data2.asString("period"));
            }

            @Override
            public boolean blank(User.Type type, Data data, Data data2) {
                if (type == null || type == User.ANONYMOUS || type == User.SYSTEM) {
                    throw new IllegalArgumentException("Invalid user");
                }
                if (data == null || !data.isMap() || data.isEmpty("secret")) {
                    throw new IllegalArgumentException("Invalid enrollment data");
                }
                if (data2 == null || !data2.isMap() || data2.isEmpty("otp")) {
                    throw new IllegalArgumentException("Invalid test data");
                }
                try {
                    Data data3 = Data.map().put("secret", data.asString("secret")).put("period", Manager.of(Config.class).get(this.type(), "otpperiod")).put("digits", Manager.of(Config.class).get(this.type(), "otpdigits")).put("algorithm", Manager.of(Config.class).get(this.type(), "otpalgorithm"));
                    String string = data2.asString("otp");
                    long l = System.currentTimeMillis();
                    byte[] byArray = Type.base32Decode(data.asString("secret"));
                    return this.checkAt(data3.asString("algorithm"), data3.asInt("period"), data3.asInt("digits"), byArray, string, l) || this.checkAt(data3.asString("algorithm"), data3.asInt("period"), data3.asInt("digits"), byArray, string, l - data3.asLong("period") * 1000L);
                }
                catch (Exception exception) {
                    Manager.of(Logger.class).fine(Multifactor.class, (Throwable)exception);
                    return false;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean check(User.Type type, Data data) {
                if (type == User.ANONYMOUS || type == User.SYSTEM) {
                    return false;
                }
                if (data == null || !data.isMap() || data.isEmpty("otp")) {
                    return false;
                }
                User.Type type2 = type;
                synchronized (type2) {
                    try {
                        Data data2 = this.privateData(type);
                        if (data2 == null || data2.isEmpty() || data2.asString("latest").equals(data.asString("otp"))) {
                            return false;
                        }
                        String string = data.asString("otp");
                        long l = System.currentTimeMillis();
                        byte[] byArray = Type.base32Decode(data2.asString("secret"));
                        if (!this.checkAt(data2.asString("algorithm"), data2.asInt("period"), data2.asInt("digits"), byArray, string, l) && !this.checkAt(data2.asString("algorithm"), data2.asInt("period"), data2.asInt("digits"), byArray, string, l - data2.asLong("period") * 1000L)) {
                            return false;
                        }
                        data2.put("latest", string);
                        this.privateData(type, data2);
                        return true;
                    }
                    catch (Exception exception) {
                        Manager.of(Logger.class).warning(Multifactor.class, (Throwable)exception);
                        return false;
                    }
                }
            }

            private boolean checkAt(String string, int n, int n2, byte[] byArray, String string2, long l) throws Exception {
                int n3 = Integer.parseInt(string2);
                long l2 = l / 1000L / (long)n;
                Mac mac = Mac.getInstance("Hmac" + string);
                mac.init(new SecretKeySpec(byArray, "Hmac" + string));
                byte[] byArray2 = mac.doFinal(ByteBuffer.allocate(8).putLong(l2).array());
                int n4 = byArray2[byArray2.length - 1] & 0xF;
                int n5 = (byArray2[n4] & 0x7F) << 24 | (byArray2[n4 + 1] & 0xFF) << 16 | (byArray2[n4 + 2] & 0xFF) << 8 | byArray2[n4 + 3] & 0xFF;
                int n6 = n5 % (int)Math.pow(10.0, n2);
                return n3 == n6;
            }

            public static String randomSecret() {
                return Type.secret(Manager.of(Security.class).randomHash());
            }

            public static String secret(String string) {
                return Type.base32Encode(Type.generateSecret(string.getBytes()));
            }

            public static String get(String string) {
                try {
                    long l = System.currentTimeMillis();
                    byte[] byArray = Type.generateSecret(string.getBytes());
                    long l2 = l / 1000L / Manager.of(Config.class).get(TOTP.class, "otpperiod").asLong();
                    Mac mac = Mac.getInstance("Hmac" + Manager.of(Config.class).get(TOTP.class, "otpalgorithm").asString());
                    mac.init(new SecretKeySpec(byArray, "Hmac" + Manager.of(Config.class).get(TOTP.class, "otpalgorithm").asString()));
                    byte[] byArray2 = mac.doFinal(ByteBuffer.allocate(8).putLong(l2).array());
                    int n = byArray2[byArray2.length - 1] & 0xF;
                    int n2 = (byArray2[n] & 0x7F) << 24 | (byArray2[n + 1] & 0xFF) << 16 | (byArray2[n + 2] & 0xFF) << 8 | byArray2[n + 3] & 0xFF;
                    int n3 = n2 % (int)Math.pow(10.0, Manager.of(Config.class).get(TOTP.class, "otpdigits").asInt());
                    return String.format("%0" + Manager.of(Config.class).get(TOTP.class, "otpdigits").asInt() + "d", n3);
                }
                catch (Exception exception) {
                    return null;
                }
            }

            private static String base32Encode(byte[] byArray) {
                StringBuilder stringBuilder = new StringBuilder();
                int n = 0;
                int n2 = 0;
                for (byte by : byArray) {
                    n2 <<= 8;
                    n2 |= by & 0xFF;
                    n += 8;
                    while (n >= 5) {
                        int n3 = n2 >>> n - 5 & 0x1F;
                        stringBuilder.append(BASE32_ALPHABET[n3]);
                        n -= 5;
                    }
                }
                if (n > 0) {
                    int n4 = (n2 <<= 5 - n) & 0x1F;
                    stringBuilder.append(BASE32_ALPHABET[n4]);
                }
                return stringBuilder.toString();
            }

            private static byte[] base32Decode(String string) {
                byte[] byArray = new byte[string.length() * 5 / 8];
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                for (char c : string.toCharArray()) {
                    int n4 = c - 50;
                    if (n4 < 0 || n4 >= REVERSE_BASE32.length) {
                        throw new IllegalArgumentException("Invalid character in Base32 string: " + c);
                    }
                    n4 = REVERSE_BASE32[n4];
                    n2 <<= 5;
                    n2 |= n4 & 0x1F;
                    if ((n3 += 5) < 8) continue;
                    byArray[n++] = (byte)(n2 >> n3 - 8 & 0xFF);
                    n3 -= 8;
                }
                return byArray;
            }

            private static byte[] generateSecret(byte[] byArray) {
                int n;
                if (byArray == null || byArray.length < 20) {
                    throw new SecurityException("Invalid or weak seed");
                }
                byte[] byArray2 = new byte[6];
                for (n = 0; n < 6; ++n) {
                    byArray2[n] = byArray[n];
                }
                for (n = 6; n < byArray.length; ++n) {
                    int n2 = n % 6;
                    byArray2[n2] = (byte)(byArray2[n2] ^ byArray[n]);
                }
                return byArray2;
            }
        }
    }

    public static abstract class Type
    extends Entity {
        private String key = null;

        public abstract void enroll(User.Type var1, Data var2);

        public boolean enrolled(User.Type type) {
            return !this.privateData(type).isEmpty();
        }

        public abstract boolean check(User.Type var1, Data var2);

        public abstract Data generate(User.Type var1, Data var2);

        public abstract boolean blank(User.Type var1, Data var2, Data var3);

        public void forget(User.Type type) {
            this.privateData(type, null);
        }

        public boolean appliesTo(User.Type type) {
            if (type == User.ANONYMOUS || type == User.SYSTEM) {
                return false;
            }
            for (Tuples.Tuple tuple : this.relations("roles")) {
                if (tuple == null || tuple.a == null || !type.hasRole((Role.Type)((Entity)tuple.a).cast())) continue;
                return true;
            }
            for (Tuples.Tuple tuple : this.relations("groups")) {
                if (tuple == null || tuple.a == null || !type.isMemberOf((Group.Type)((Entity)tuple.a).cast())) continue;
                return true;
            }
            return false;
        }

        protected final Data privateData(User.Type type) {
            try {
                if (type == null) {
                    return Data.map();
                }
                Data data = Manager.of(Vault.class).get(Manager.of(Security.class).hash(this.id() + "." + type.id()), this.key);
                if (data.isEmpty()) {
                    return data;
                }
                return Json.decode(data.asString());
            }
            catch (Exception exception) {
                return Data.map();
            }
        }

        protected final void privateData(User.Type type, Data data) {
            if (type == null) {
                throw new IllegalArgumentException("Invalid user");
            }
            if (data != null && !data.isMap()) {
                throw new IllegalArgumentException("Invalid data");
            }
            try {
                if (data == null) {
                    Manager.of(Vault.class).remove(Manager.of(Security.class).hash(this.id() + "." + type.id()), this.key);
                } else {
                    Manager.of(Vault.class).set(Manager.of(Security.class).hash(this.id() + "." + type.id()), data, this.key);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Operation failed");
            }
        }

        @Override
        public Data snapshot() {
            return super.snapshot().put("key", this.key);
        }
    }
}

