/*
 * Decompiled with CFR 0.152.
 */
package local;

import aeonics.Boot;
import aeonics.Plugin;
import aeonics.Protocols;
import aeonics.entity.Database;
import aeonics.entity.Debug;
import aeonics.entity.Discard;
import aeonics.entity.Flow;
import aeonics.entity.Probe;
import aeonics.entity.Queue;
import aeonics.entity.Registry;
import aeonics.entity.Scheduled;
import aeonics.entity.Storage;
import aeonics.entity.Topic;
import aeonics.entity.security.Group;
import aeonics.entity.security.Multifactor;
import aeonics.entity.security.Policy;
import aeonics.entity.security.Provider;
import aeonics.entity.security.Role;
import aeonics.entity.security.Rule;
import aeonics.entity.security.User;
import aeonics.manager.Config;
import aeonics.manager.Lifecycle;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.manager.Network;
import aeonics.template.Factory;
import aeonics.template.Parameter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public class Main
extends Plugin {
    public String summary() {
        return "Core System";
    }

    public String description() {
        return "Defines the default behavior of the system.";
    }

    public Main() {
        String string = System.getProperty("AEONICS_MANAGER_LOGGER_LEVEL");
        if (string == null || string.isBlank()) {
            string = System.getenv("AEONICS_MANAGER_LOGGER_LEVEL");
        }
        if (string == null || string.isBlank()) {
            string = "700";
        }
        try {
            Integer.parseInt(string);
        }
        catch (Exception exception) {
            string = "700";
        }
        int n = Integer.parseInt(string);
        System.setProperty("AEONICS_MANAGER_LOGGER_LEVEL", "" + n);
        try {
            Class.forName("aeonics.manager.Logger");
            Class.forName("aeonics.manager.Executor");
            Class.forName("aeonics.manager.Lifecycle");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void start() {
        Protocols.register((String)"storage", (URLStreamHandler)new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL uRL) throws IOException {
                Storage.Type type = (Storage.Type)Registry.of(Storage.class).get(uRL.getHost());
                if (type == null) {
                    throw new IOException("Storage " + uRL.getHost() + " not found");
                }
                final byte[] byArray = type.get(uRL.getFile());
                if (byArray == null) {
                    throw new IOException("Path " + uRL.getFile() + " not found on storage " + uRL.getHost());
                }
                return new URLConnection(uRL){

                    @Override
                    public void connect() {
                        this.connected = true;
                    }

                    @Override
                    public InputStream getInputStream() {
                        return new ByteArrayInputStream(byArray);
                    }
                };
            }
        });
        Lifecycle.before(Lifecycle.Phase.LOAD, this::onBeforeLoad);
        Lifecycle.on(Lifecycle.Phase.LOAD, this::onLoad);
        Boot.spark(() -> {
            Lifecycle lifecycle = Manager.of(Lifecycle.class);
            if (lifecycle == null) {
                Manager.of(Logger.class).severe(Lifecycle.class, (Object)"Missing required implementation");
                return;
            }
            lifecycle.boot();
        });
    }

    public void onBeforeLoad() {
        Factory.add(new Database());
        Factory.add(new Scheduled());
        Factory.add(new Probe());
        Factory.add(new Queue());
        Factory.add(new Storage.File());
        Factory.add(new Storage.Memory());
        Factory.add(new Storage.Database());
        Factory.add(new Topic());
        Factory.add(new Flow());
        Factory.add(new Group());
        Factory.add(new Multifactor.TOTP());
        Factory.add(new Policy.Allow());
        Factory.add(new Policy.Deny());
        Factory.add(new Policy.TargetedAllow());
        Factory.add(new Policy.TargetedDeny());
        Factory.add(new Provider.Local());
        Factory.add(new Role());
        Factory.add(new Rule.And());
        Factory.add(new Rule.AskProviders());
        Factory.add(new Rule.MatchAll());
        Factory.add(new Rule.MatchAttribute());
        Factory.add(new Rule.MatchContext());
        Factory.add(new Rule.MatchNone());
        Factory.add(new Rule.Or());
        Factory.add(new Rule.Not());
        Factory.add(new Rule.Role());
        Factory.add(new Rule.Xor());
        Factory.add(new User());
        Debug.register();
        Discard.register();
    }

    public void onLoad() {
        Config config = Manager.of(Config.class);
        config.declare(Plugin.class, ((Parameter)((Parameter)((Parameter)new Parameter("path").summary("Plugins directory")).description("The path to the plugins directory. This parameter must be set in the command line.")).format("text")).rule(Parameter.Rule.PATH).optional(false));
        config.declare("aeonics.hardware.cpu", ((Parameter)((Parameter)((Parameter)new Parameter("limit").summary("CPU Limit")).description("This parameter defines the number of system worker threads to potentially limit the number of usable cores. It can be set to a higher value than real CPU cores.")).format("number")).rule(Parameter.Rule.DIGIT));
        config.declare(Network.class, (Parameter)((Parameter)((Parameter)((Parameter)new Parameter("tls.default.ciphers").summary("Default TLS Ciphers")).description("This parameter is a JSON list of default TLS ciphers that should be used to secure network communications. Refer to standard JSSE Cipher Suite Names.")).format("json")).rule(Parameter.Rule.JSON_LIST).defaultValue("[TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_DHE_RSA_WITH_AES_256_GCM_SHA384,TLS_DHE_RSA_WITH_AES_128_GCM_SHA256,TLS_AES_256_GCM_SHA384,TLS_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256]"));
        config.declare(Network.class, (Parameter)((Parameter)((Parameter)((Parameter)new Parameter("tls.default.protocols").summary("Default TLS Protocols")).description("This parameter is a JSON list of default TLS protocols that should be used to secure network communications. Refer to standard SSLContext Algorithms.")).format("json")).rule(Parameter.Rule.JSON_LIST).defaultValue("[TLSv1.3,TLSv1.2]"));
    }
}

