@echo off
setlocal EnableDelayedExpansion

:: ======================================
:: Environment variables
@set CLASSPATH=.
@set LOG_LEVEL=-DAEONICS_MANAGER_LOGGER_LEVEL=800
@set PLUGIN_DIR=-DAEONICS_PLUGIN_PATH=plugins
@set args=%PLUGIN_DIR% %LOG_LEVEL%
:: ================================

:: ======================================
:: Check Java version
@java -version >nul 2>&1
if errorlevel 1 (
    echo [ERROR] Java not found or not executable. Please install Java 11 or higher.
    exit /b 1
)
for /f "delims=" %%L in ('java -version 2^>^&1') do if not defined JVLINE set "JVLINE=%%L"
for /f tokens^=2^ delims^=^" %%V in ("!JVLINE!") do set "JVER=%%V"
for /f "tokens=1 delims=." %%N in ("!JVER!") do set "JMAJOR=%%N"
for /f "delims=0123456789" %%X in ("!JMAJOR!") do set "JMAJOR=0"
if !JMAJOR! LSS 11 (
  echo [ERROR] Java version !JVER! is too old. Aeonics requires 11 or higher.
  exit /b 1
)

:: ======================================
:: Run
@java %args% --module-path ae.jar --module aeonics.boot/aeonics.Boot
endlocal